/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.lock;

import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.lock.RequestId;

class RequestItem {
    private RequestId mRequestId;
    private int mLockType;
    private int mStatus;
    private int mCount = 1;
    private String[] lockTypes = new String[]{"R ", "W ", "GR", "GW", "EW"};
    private String[] lockStatuses = new String[]{"WAITING", "READY  ", "RUNNING", "PENDING"};

    public RequestItem(RequestId requestId, int n) {
        this.mRequestId = requestId;
        this.mLockType = n;
    }

    public RequestItem(Thread thread, Lock lock, int n) {
        this.mRequestId = new RequestId(thread, lock);
        this.mLockType = n;
    }

    public boolean equals(Object object) {
        RequestItem requestItem = (RequestItem)object;
        return this.mRequestId == requestItem.mRequestId;
    }

    public String toString() {
        String string = "FAILED ";
        if (this.mStatus >= 0 && this.mStatus < this.lockStatuses.length) {
            string = this.lockStatuses[this.mStatus];
        }
        return this.lockTypes[this.mLockType] + " " + string + " " + this.mCount + " " + this.mRequestId.getLock() + " " + this.mRequestId.getThread();
    }

    public RequestId getRequestId() {
        return this.mRequestId;
    }

    public Thread getThread() {
        return this.mRequestId.getThread();
    }

    public Lock getLock() {
        return this.mRequestId.getLock();
    }

    public int getLockType() {
        return this.mLockType;
    }

    public void setStatus(int n) {
        this.mStatus = n;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void increaseCount() {
        ++this.mCount;
    }

    public void decreaseCount() {
        --this.mCount;
    }

    public int getCount() {
        return this.mCount;
    }
}

